﻿<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://www.fusioncharts.com/jsp/core" prefix="fc" %> 
<%@ taglib prefix="tags" tagdir="/WEB-INF/tags" %>
<jsp:useBean id="chartData" class="com.fusioncharts.sampledata.MultiLingualData"/>
<c:set var="folderPath" value="../../FusionCharts/"/>
<c:set var="jsPath" value="${folderPath}" scope="request"/>
<c:set var="assetCSSPath" value="../assets/ui/css/" scope="request"/>
<c:set var="assetJSPath" value="../assets/ui/js/" scope="request"/>
<c:set var="assetImagePath" value="../assets/ui/images/" scope="request"/>
<c:set var="title" value="FusionCharts UTF8 Example" scope="request"/>
<c:set var="header1" value="FusionCharts UTF8 Example with 日本語 (Japanese) text" scope="request"/>
<c:set var="header2" value="Example using data from database" scope="request"/>
<c:set target="${pageContext.response}" property="contentType" value="text/html; charset=UTF-8"/>
<tags:template3> 
<%--
				
				In this example, we show how to use UTF characters in chart created with FusionCharts 
				Here, the XML data for the chart is dynamically generated by PieDataJapanese.jsp. 
				
				
				In this example, FusionCharts uses dataURL method to get the xml from the data in the database. 
				In order to store and retrieve UTF8 characters from database, in our example, MySQL,
				we have to alter the database default charset to UTF8. This can be done using the command:
				ALTER DATABASE DEFAULT CHARACTER SET = utf8; on the "factorydb" database.
			    For this example, we will use another table Japanese_Factory_Master containing the names of the factories
			    in Japanese language. This table should also be defined to use UTF8 as DEFAULT CHARSET. 
			    The sql script that needs to be executed before running this example is UTFExampleTablesCreation.sql 
			    present in Code/JSP/DB folder.
				
				
				The pageEncoding and chartSet headers for the page have been set to UTF-8
				in the first line of this jsp file.
					
				--%>
					
<fc:render chartId="${chartData.chartId}" swfFilename="${folderPath}${chartData.filename}" width="${chartData.width}" height="${chartData.height}" xmlUrl="${chartData.dynamicurl}" />
</tags:template3> 