<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="tags" tagdir="/WEB-INF/tags"%>
<%@ taglib uri="http://www.fusioncharts.com/jsp/core" prefix="fc"%>
<jsp:useBean id="factoriesBean"
	class="com.fusioncharts.sampledata.FactoriesBean" />
<jsp:useBean id="chart2Data"
	class="com.fusioncharts.sampledata.EmptyRenderData" />
<c:set var="folderPath" value="../../FusionCharts/" />
<c:set var="title" value="FusionCharts - Database + JavaScript Example"
	scope="request" />
<c:set var="header1"
	value="FusionCharts Database + JavaScript (dataURL method) Example"
	scope="request" />
<c:set var="header2"
	value="Inter-connected charts - Click on any pie slice to see detailed
			chart below."
	scope="request" />
<c:set var="intro"
	value="The charts in this page have been dynamically generated using
			data contained in a database."
	scope="request" />
<c:set var="jsPath" value="${folderPath}"
	scope="request" />
<c:set var="assetCSSPath" value="../assets/ui/css/" scope="request"/>
<c:set var="assetJSPath" value="../assets/ui/js/" scope="request"/>
<c:set var="assetImagePath" value="../assets/ui/images/" scope="request"/>	

      <%-- 
			In this example, we show a combination of database + JavaScript (dataURL method)
			rendering using FusionCharts.
			
			The entire app (page) can be summarized as under. This app shows the break-down
			of factory wise output generated. In a pie chart, we first show the sum of quantity
			generated by each factory. These pie slices, when clicked would show detailed date-wise
			output of that factory. The detailed data would be dynamically pulled by the column
			chart from another JSP page. There are no page refreshes required. Everything
			is done on one single page.
			
			The XML data for the pie chart is fully created in JSP at run-time. JSP interacts
			with the database and creates the XML for this.
			Now, for the column chart (date-wise output report), each time we need the data
			we dynamically submit request to the server with the appropriate factoryId. The server
			responds with an XML document, which we accept and update chart at client side.
			
			--%>      


<tags:template2>
	<SCRIPT LANGUAGE="JavaScript">
	/** 
	 * updateChart method is invoked when the user clicks on a pie slice.
	 * In this method, we get the index of the factory after which we request for XML data
	 * for that that factory from FactoryData.asp, and finally
	 * update the Column Chart.
	 *	@param	factoryIndex	Sequential Index of the factory.
	 */
	function updateChart(factoryIndex) {
		//DataURL for the chart
		var strURL = "FactoryData.jsp?factoryId=" + factoryIndex;

		//Sometimes, the above URL and XML data gets cached by the browser.
		//If you want your charts to get new XML data on each request,
		//you can add the following line:
		//strURL = strURL + "&currTime=" + getTimeForURL();
		//getTimeForURL method is defined below and needs to be included
		//This basically adds a ever-changing parameter which bluffs
		//the browser and forces it to re-load the XML data every time.

		//URLEncoding - NOT NECESSARY WHEN USING JS API.
		//strURL = escape(strURL);

		//Get reference to chart object using Dom ID "FactoryDetailed"
		var chartObj = FusionCharts('FactoryDetailed');
		//Send request for XML
		chartObj.setXmlUrl(strURL);
	}
	/**
	 * getTimeForURL method returns the current time 
	 * in a URL friendly format, so that it can be appended to
	 * dataURL for effective non-caching.
	 */
	function getTimeForURL() {
		var dt = new Date();
		var strOutput = "";
		strOutput = dt.getHours() + "_" + dt.getMinutes() + "_"
				+ dt.getSeconds() + "_" + dt.getMilliseconds();
		return strOutput;
	}
</SCRIPT>
	<%-- Create the chart - Pie 3D Chart with data contained in bean --%>

	<fc:render chartId="${factoriesBean.chartId}"
		swfFilename="${folderPath}${factoriesBean.filename}"
		width="${factoriesBean.width}" height="${factoriesBean.height}"
		debugMode="false"  xmlData="${factoriesBean.xml}" />

   <BR/>
	<BR/>
	<%--  
				Column 2D Chart with changed "No data to display" message
				We initialize the chart with <chart></chart>
    --%>

	<fc:render chartId="${chart2Data.chartId}"
		swfFilename="${folderPath}${chart2Data.filename}${chart2Data.noDataParameter}"
		width="${chart2Data.width}" height="${chart2Data.height}"
		debugMode="false" registerWithJS="true" xmlData="${chart2Data.xml}" />
</tags:template2>
