<%
'We've included ../Includes/FusionCharts.asp, which contains functions
'to help us easily embed the charts.
%>
	<!-- #INCLUDE FILE="../Includes/FusionCharts.asp" -->
	<!-- #INCLUDE FILE="../Includes/DBConn.asp" -->
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<HTML>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

        <TITLE>
	FusionCharts - AJAX + Database Example
        </TITLE>
        <link href="../assets/ui/css/style.css" rel="stylesheet" type="text/css" />

        <%
        'In this example, we show a combination of database + AJAX + JavaScript
        'rendering using FusionCharts.

        'The entire app (page) can be summarized as under. This app shows the break-down
        'of factory wise output generated. In a pie chart, we first show the sum of quantity
        'generated by each factory. These pie slices, when clicked would show detailed date-wise
        'output of that factory. The detailed data would be dynamically pulled by the column
        'chart from another ASP page. There are no page refreshes required. Everything
        'is done on one single page.

        'The XML data for the pie chart is fully created in ASP at run-time. ASP interacts
        'with the database and creates the XML for this.
        'Now, the the drilldown chart (date-wise output report) is provided by AJAX
        'each time we need to see detailed data we click on a pie slice
        'Using AJAX (we use jQuery here for AJAX implementation) we dynamically submit request
        'to the server with the appropriate factoryId. The server
        'responds with an HTML for chart as well as XML document,
        'which we accept and update a section of our page at client side.
        %>
        <SCRIPT LANGUAGE="Javascript" SRC="../../FusionCharts/jquery.js"></script>
        <SCRIPT LANGUAGE="Javascript" SRC="../../FusionCharts/FusionCharts.js"></script>
        <%
        'You need to include the above JS files, if you intend to embed the chart using JavaScript.
        'jQuery is used to perform AJAX submit and handling AJAX response.
        'When you make your own charts, make sure that the path to this JS file is correct. Else, you would get JavaScript errors.
        %>


        <SCRIPT LANGUAGE="JavaScript">

            /**
             * updateChart method is invoked when the user clicks on a pie slice.
             * In this method, we get the index of the factory after which we request for detailed chart
             * for that that factory from FactoryChart.asp.
             *
             *	@param	factoryIndex	Sequential Index of the factory.
             */
            function updateChart(factoryIndex){

                // build the AJAX request Url
                var strURL = "FactoryChart.asp?FactoryId=" + factoryIndex;

                // send ajax request
                // and when response of got successfully back  (which means the HTML for chart is received)
                // update the response to the "detailedChart" div.
                // NOTE : HTML embedding method is used in thea AJAX response string
                $.ajax({
                    type: "GET",
                    url: strURL,
                    success: function(msg){
                        $("#detailedChart").show().html(msg);
                    }
                });


            }

        </SCRIPT>
        <!--[if IE 6]>
        <script>
                <script type="text/javascript" src="../assets/ui/js/DD_belatedPNG_0.0.8a-min.js"></script>
          /* select the element name, css selector, background etc */
          DD_belatedPNG.fix('img');

          /* string argument can be any CSS selector */
        </script>
        <![endif]-->

        <style type="text/css">
            h2.headline {
                font: normal 110%/137.5% "Trebuchet MS", Arial, Helvetica, sans-serif;
                padding: 0;
                margin: 25px 0 25px 0;
                color: #7d7c8b;
                text-align: center;
            }
            p.small {
                font: normal 68.75%/150% Verdana, Geneva, sans-serif;
                color: #919191;
                padding: 0;
                margin: 0 auto;
                width: 664px;
                text-align: center;
            }
        </style>
        <%
        'You need to include the following JS file, if you intend to embed the chart using JavaScript.
        'Embedding using JavaScripts avoids the "Click to Activate..." issue in Internet Explorer
        'When you make your own charts, make sure that the path to this JS file is correct. Else, you
        'would get JavaScript errors.
        %>

    </head>
    <BODY>

        <div id="wrapper">

            <div id="header">
                <div class="back-to-home"><a href="../index.html">Back to home</a></div>

                <div class="logo"><a class="imagelink"  href="index.html"><img src="../assets/ui/images/fusionchartsv3.2-logo.png" width="131" height="75" alt="FusionCharts v3.2 logo" /></a></div>
                <h1 class="brand-name">FusionCharts</h1>
                <h1 class="logo-text">FusionCharts AJAX and Database Example</h1>
            </div>

            <div class="content-area">
                <div id="content-area-inner-main">
                    <h2 class="headline">Inter-connected charts - Click on any pie slice to see detailed chart below</h2>

                    <div class="gen-chart-render">

                        <CENTER>

                            <%
							Dim oRs, strQuery
							
                            'strXML will be used to store the entire XML document generated
                            'Generate the chart element
                            strXML = "<chart caption='Factory Output report' subCaption='By Quantity' pieSliceDepth='30' showBorder='1' formatNumberScale='0' numberSuffix=' Units' >"

							'Create the recordset to retrieve data
							Set oRs = Server.CreateObject("ADODB.Recordset")

                            ' Fetch all factory records
                            strQuery = "select fm.FactoryId, fm.FactoryName, sum(fo.Quantity) as TotOutput from Factory_Master fm, Factory_Output fo where fm.FactoryId=fo.FactoryID group by fm.FactoryId, fm.FactoryName"
                            Set oRs = oConn.Execute(strQuery)

                            'Iterate through each factory
                            If Not oRs Is Nothing Then
                                While Not oRs.Eof 
                                    'Generate <set label='..' value='..' link='..' />
                                    'Note that we're setting link as updateChart(factoryIndex) - JS Function
                                    strXML = strXML & "<set label='" & ors("FactoryName") & "' value='" & ors("TotOutput") & "' link='javaScript:updateChart(" & ors("FactoryId") & ")'/>"
                                    'free the resultset
									oRs.MoveNext
                                Wend
							End If
                            'Finally, close <chart> element
                            strXML = strXML & "</chart>"

                            'Create the chart - Pie 3D Chart with data from strXML
                            Call renderChart("../../FusionCharts/Pie3D.swf", "", strXML, "FactorySum", 500, 250, false, false)
                            %>
                            <BR>
                            <!-- div that is going to contain chart from AJAXC response -->
                            <div id="detailedChart" style="width:600px;height:300px;display:none;"></div>

                        </CENTER>
                    </div>
                    <div class="clear"></div>
                    <p>&nbsp;</p>
                    <p class="small">The charts in this page have been dynamically generated using data contained in a database.</p>
                    <p class="small">The detailed charts along with the dynamic data are received using AJAX.</p>


                    <div class="underline-dull"></div>
                </div>
            </div>

            <div id="footer">
                <ul>
                    <li><a href="../index.html"><span>&laquo; Back to list of examples</span></a></li>
                    <li class="pipe">|</li>
                    <li><a href="../NoChart.html"><span>Unable to see the chart above?</span></a></li>
                </ul>
            </div>
        </div>
    </BODY>
</HTML>
