<?
/* numbers2words -numbers2words.php-

   converts numbers to words

   numbers range from 0 to 999.999.999.999.999

   Note: argument to n2w is a string use
   strings for big number (usally bigger then 2^32)
   see example.php

   For british (GB) numbers call with a optional
   second argument = 1.

   British (GB)
   n2w('1000000000',1) gives "one milliard"
   n2w('1000000000000',1) gives "one billion"

   American (US/FR)
   n2w('1000000000') gives "one billion"
   n2w('1000000000000') gives "one trillion"

   Version 0.2b
   Last change: 2002/09/12
   copyrigth 2002 Email Communications, http://www.emailcommunications.nl/
   written by Bas Jobsen (bas@startpunt.cc)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
   
*/

/*

Clase extendida con el formato de numeros y paso a euros en espaol
por Ivn Garca igg10@alu.ua.es

*/

class numberstowords
{
function hunderds($number)
{

	$test=$number*1;
	if (empty($test))return;
	$lasts=array('un','dos','tres','cuatro','cinco','seis','siete','ocho','nueve');
	$teens=array('once','doce','trece','catorce','quince','dieciseis','diecisiete','dieciocho','diecinueve');
	$teen=array('diez','veinte','treinta','cuarenta','cincuenta','sesenta','setenta','ochenta','noventa');
	$cientos=array('ciento','doscientos','trescientos','cuatrocientos','quinientos','seiscientos','setecientos','ochocientos','novecientos');

	/* written by bas@startpunt.cc */
	
	$string='';
	$j=strlen($number);
	$done=false;
	
	for($i=0; $i<strlen($number); $i++)
	{

		if($j==2) 
		{
		if(strlen($number)>2)
		{
		if($number[0]!=0) {
		$string= $cientos[$number[0]-1];
		}
		 
		if(substr($number,$i+1))$string.= ' ';
		}
		if ($number[$i]==1)
		{
			if($number[$i+1]==0) $string.=$teen[$number[$i]-1].' y ';
			else 
			{
			$string.=$teens[$number[$i+1]-1];
			$done=true;
			}
		}
		else
		{
			if(!empty($teen[$number[$i]-1]))$string.=$teen[$number[$i]-1].' y ';
		}
	}

		elseif($number[$i]!=0 && !$done) $string.=$lasts[$number[$i]-1];

		$j--;
	}

return $string;
}	

function n2w($number,$uk=0)
{
	if(!is_string($number))$number.="";
	if(!$uk)$many=array('', ' mil ',' millon ',' billon ',' trillon ');
	else $many=array('', ' miles ',' millones ',' millares ',' billones ');
	$string='';
	if(strlen($number)%3!=0)
	{
	$string.=$this->hunderds(substr($number,0, strlen($number)%3 ));
	$string.=$many[floor(strlen($number)/3)];
		
	}
	for($i=0; $i<floor(strlen($number)/3); $i++)
	{
		
		$string.=$this->hunderds(substr($number,strlen($number)%3+($i*3),3));
		if($number[strlen($number)%3+($i*3)]!=0)$string.=$many[floor(strlen($number)/3)-1-$i];

	}	

	return $string;
}


function n2euro($number){
list($euros,$centimos) = explode(".",$number);

$money = $this->n2w($euros);
$money .= " euros";
if($centimos!="" and $centimos>0){
$money .= ' con ';
$money .= $this->n2w($centimos);
$money .= ' cntimos';
}
return($money);
}
}
?>
