<?php
/*
 * Filename.....: finetable.php
 * Aufgabe......: Prints a panel with rounded corners.
 * Parameter....: none
 * Erstellt am..: 28. Mrz 2002
 *       _  __      _ _
 *  ||| | |/ /     (_) |        Wirtschaftsinformatiker IHK
 * \. ./| ' / _ __  _| |_ ___   www.ingoknito.de
 * - ^ -|  < | '_ \| | __/ _ \  
 * / - \| . \| | | | | || (_) | Peter Klauer
 *  ||| |_|\_\_| |_|_|\__\___/  06131-651236
 * mailto.......: knito@knito.de
 *
 * Changes:
 * 2002-10-07: Deleted some odd '#' out of default colors and put them into the code.
 * 2002-05-20: Define global var $fine_table_class_loaded to stop
 *             errors when reloaded multiple times.
 *             This is PHP3 compatible behaviour. 
 * 2002-05-15: AMAYA feeling. An attempt to have it look a little nicer with the
 *             Amaya Browser from http://www.w3.org/Amaya
 *             Still not good, but better than before the changes to ft_outline()
 * 2002-05-01: New Class Function: Change bodybgcolor( $newcolor, $withline=true )
 *             Used between $this->printtop() and $this->printbottom()
 *             to change the next row's colour. Prints another separating
 *             line before the new row starts if parameter $withline is true.
 * 2002-04-14: Changed the CSS class for the container-<td> from
 *             ft_caption and ft_body to ftcaption and ftbody
 * 2002-04-08: finetable.php no longer produces images.
 *             the class ftable is here within finetable.php
 *             - finetable.php produces the IMAGE_GENERATOR, if it is missing
 *             Write permission is needed to do it!
 * 2002-04-07: - finetable.php produces BLANK_IMAGE, if it is missing
 *             Write permission is needed to do it!
 * 2002-04-05: error in ft_line() corrected
 * 2002-04-04: ft_corner uses ft_blank for transparent image when called with $img == 0
 *             new variable $blank points to blank gif (42 Bytes)
 *             ft_blank rewritten to use ft_blank.gif.
 *             ft_img2.php is shorter than ft_img.php. It does no
 *             more produce a transparent gif. Since every transparent images now
 *             is done with ft_blank.gif, the acceleration is visible.
 * 2002-03-02: Changed $me to point to the much shorter ft_img.php
 * 2002-03-30: Some finetables have another captionbgcolor
 * 2002-04-01: My big sister corrected the page where the english was not so good.
 */

if( !isset( $fine_table_class_loaded ))
{
    $fine_table_class_loaded = 1;
    # now you can rename the graphic files at will.
    define ( 'IMAGE_GENERATOR', 'ft_img2.php' ); // must have a valid .php? ending
    define ( 'BLANK_IMAGE', 'ft_blank.gif' ); 
      
    #
    # This worked fine for me:
    # the directory images was empty and finetable.php
    # created the files as needed.
    # Example how to put the created files into a directory "images".
    # The directory "images" must exist!
    #
    # $me = 'images/'. IMAGE_GENERATOR ; // 428 byte cannot make a transparent gif
    # $blank = 'images/'.BLANK_IMAGE; // 42 byte transparent gif
    #
    # I don't know if you have a subdirectory "images", 
    # so I put the files into the actual directory.
    $me = IMAGE_GENERATOR ; // 428 byte cannot make a transparent gif
    $blank = BLANK_IMAGE; // 42 byte transparent gif
    
    #
    # if the filename is BLANK_IMAGE and it does not exist, then create
    # it in the path specified
    # this was done for phpclasses, because I see no way to upload a binary file
    # but it is useful, isn't it?
    #
    if( ( substr($blank, -(strlen(BLANK_IMAGE))) == BLANK_IMAGE ) && (!file_exists( $blank )))
    {
        $buffer = base64_decode( 'R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAQAIBRAA7' );
        $handle = fopen( $blank, 'w' ) or die( "Finetable: can't open $blank for writing." );
        fwrite( $handle, $buffer );
        fclose( $handle );
    }
    
    #
    # if the $me is IMAGE_GENERATOR and 
    # file $me does not exist, then create it.
    #
    if( (substr($me, -(strlen(IMAGE_GENERATOR))) == IMAGE_GENERATOR) && (!file_exists( $me )))
    {
        $buffer =
        '<'.'?'."php \$h='R0lGODlhDAAMAIAAAP///wD/ACH5BAEAAAEALAAAAAAMAAwAQAIU';".
        "switch(\$img){".
        "case 1:\$t='jH+goe1rnkNMVokzvS1pbmXimBUAOw==';break;".
        "case 2:\$t='hIOZxn3eFlQBumrzoVpmpD3haBQAOw==';break;".
        "case 3:\$t='hI+pwZrhomuPWYkRxHvSehnWyBQAOw==';break;".
        "default:\$t='hI8WmxgNo3pyWSohjlszfnmXdRQAOw==';}".
        "\$i=base64_decode(\$h.\$t);".
        "\$f=pack('H*',substr(\$color,-6));".
        "\$o=substr(\$i,0,13).\$f.substr(\$i,-(strlen(\$i)-16));".
        "Header('Content-type:image/gif');".
        "print(\$o);".'?'.'>';    
        $handle = fopen( $me, 'w' ) or die( "Finetable: can't open $me for writing." );
        fwrite( $handle, $buffer );
        fclose( $handle );
    }
     
    function ft_line( $lineheight, $linecolor, $bgcolor='FFFFFF' )
    {
        return( '<tr bgcolor="#'.$bgcolor.'"><td colspan=3 bgcolor="#'.
            $linecolor.'" height="'.$lineheight.'">'.
            ft_blank(1,$lineheight).'</td></tr>' );
    }
    
    function ft_outline( $img1, $img2, $radius=12, $color='FFFFFF' )
    {
        return( '<tr>'.ft_corner( $img1, $radius, $color ). 
        '<td width="100%" height="'.ceil($radius/2).'" bgcolor="#'.$color.'">'.
        ft_blank(1, ceil($radius/2) ).'</td>'.
        ft_corner( $img2, $radius, $color ).'</tr>' );
    }
    
    function ft_corner( $img, $radius=12, $color='FFFFFF' )
    {
        global $me;
    
        if( $img == 0 )
        {
            $imgstring = ft_blank( $radius, $radius );
        }
        else
        {
            $imgstring = '<img src="'.$me.'?img='.$img.'&amp;color='.$color.
                '" height="'.$radius.'" width="'.$radius.'" alt="">';
        }
        return( '<td width="'.$radius.'" height="'.$radius.'">'.$imgstring.'</td>');
    }
    
    function ft_inline( $content, $type=0, $radius=12, $color='FFFFFF' )
    {
        switch( $type )
        {
            case 0: $class='ftcaption'; break;
            case 1: $class='ftbody'; break;
        }
        # valid content needed for netscape to render empty cells in #FFFFFF
        if( strlen( trim( $content ) ) == 0 ) $content = ft_blank( '100%', $radius );
        
        return( '<tr bgcolor="#'.$color.'">'.ft_corner(0,$radius). // ft_corner() for NS only
        '<td width="100%" class="'.$class.'">'.$content.'</td>'.
        ft_corner(0,$radius).'</tr>' );
    }
    
    
    function ft_blank( $width=12, $height=12 )
    {
        global $blank;
        return( '<img src="'.$blank.'" alt="" width="'.$width.'" height="'.$height.'">' );
    }
    
    function ft_table_start( $width='100%', $radius=12, $summary='' )
    {
        return ('<table width="'.$width.'" summary="'.$summary.
        '" border=0 cellpadding=0 cellspacing=0>'.
        '<colgroup><col width="'.$radius.'"><col><col width="'.
        $radius.'"></colgroup>');
    }
    
    function ft_table_stop( )
    {
        return ('</table>');
    }
    
    function blanker( $width=12, $height=12 )
    {
        echo ft_blank( $width, $height );
    }
    
    function ft_upperhalf(
        $caption, 
        $linecolor='800000', 
        $lineheight=1,
        $radius=12, 
        $width='100%',
        $bgcolor='FFFFFF', 
        $summary='',
        $captionbgcolor='' // new on march 31, 2002 
        )
    {
    if( strlen( $captionbgcolor ) == 6 )
    {
        $uppercolor = $captionbgcolor;
    }
    else
    {
        $uppercolor = $bgcolor;
    }
    return(
        ft_table_start( $width, $radius, $summary ). 
        ft_outline( 1, 2, $radius, $uppercolor ).
        ft_inline( $caption, 0, $radius, $uppercolor ).
        ft_line( $lineheight, $linecolor, $uppercolor ).
        ft_inline( '', 1, $radius, $bgcolor ).
        '<tr bgcolor="#'.$bgcolor.'">'.ft_corner(0,$radius).
        '<td width="100%" class="ftbody">');
    }
    
    function ft_finetable( 
        $caption, 
        $bodytext, 
        $linecolor='800000', 
        $lineheight=1,
        $radius=12, 
        $width='100%',
        $bgcolor='FFFFFF', 
        $summary='',
        $captionbgcolor='' ) // new on march 31, 2002
    {
    
    return(
        ft_upperhalf( $caption, $linecolor, $lineheight,
            $radius, $width, $bgcolor, $summary, $captionbgcolor ).
        $bodytext.
        ft_lowerhalf($radius, $bgcolor ));
    }
    
    function ft_lowerhalf( $radius=12, $bgcolor='FFFFFF' )
    {
    return( '</td>'.ft_corner(0,$radius).'</tr>'.ft_outline( 4, 3, $radius, $bgcolor).ft_table_stop());
    }
          
    function finetable( 
        $caption, 
        $bodytext, 
        $linecolor='800000', 
        $lineheight=1,
        $radius=12, 
        $width='100%',
        $bgcolor='FFFFFF', 
        $summary='',
        $captionbgcolor='' )
    {
    
    echo ft_finetable( $caption, $bodytext, $linecolor, $lineheight, 
        $radius, $width, $bgcolor, $summary, $captionbgcolor );
    }
    
    class ftable
    {
        var $caption = 'Untitled'; // some text
        var $captionbgcolor = 'FFFFFF'; // white
        
        var $bodytext = 'Please give me content!'; // some more text
        var $bodybgcolor = 'FFFFFF'; // white
        
        var $linecolor = '800000'; // maroon
        var $lineheight = 1;
        
        var $width = '100%';
        var $radius = 12;
        var $summary = ''; // <table> - summary needed for blind people
        
        #--------------------------------------
        # printall()
        #
        # prints entire table
        #
        function printall()
        {
            finetable( 
                $this->caption, 
                $this->bodytext, 
                $this->linecolor, 
                $this->lineheight,
                $this->radius, 
                $this->width,
                $this->bodybgcolor, 
                $this->summary,
                $this->captionbgcolor );
                
        } // class-function printall()
        
        #--------------------------------------
        # printupper()
        #
        # prints upper half of finetable
        # this is helpful when large blocks of code have to be surrounded with
        # a finetable.
        #
        function printtop()
        {
            echo ft_upperhalf( 
                $this->caption, 
                $this->linecolor, 
                $this->lineheight,
                $this->radius, 
                $this->width, 
                $this->bodybgcolor, 
                $this->summary, 
                $this->captionbgcolor );
        } // class-function printupper()
        
        #--------------------------------------
        # printlower()
        #
        # prints the lower part of the finetable
        # 
        function printbottom()
        {
            echo ft_lowerhalf( $this->radius, $this->bodybgcolor );
        } // class-function printlower()
        
    # 2002-05-01: New Class Function: Changebodybgcolor( $newcolor, $withline=true )
        function ChangeBodybgcolor( $newcolor, $withline = true )
        {
            # print end of table line
            
            echo '</td>'.ft_corner( 0, $this->radius, $this->bodybgcolor );
            echo ft_inline( '', 1, $this->radius, $this->bodybgcolor );
            
            if( $withline ) echo ft_line( $this->lineheight, $this->linecolor, $this->bodybgcolor );
            
            $this->bodybgcolor = $newcolor;
            echo ft_inline( '', 1, $this->radius, $this->bodybgcolor ).
            '<tr bgcolor="#'.$this->bodybgcolor.'">'.ft_corner(0,$radius).
            '<td width="100%" class="ftbody">';                 
        }
        
    } // class ftable
} // if strlen( 'IMAGE_GENERATOR' ) == 0 )
?>