/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter;

import com.fusioncharts.exporter.beans.ChartMetadata;
import com.fusioncharts.exporter.beans.ExportBean;
import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.FusionChartsExportData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class FusionChartsExportHelper {
    private static HashMap mimeTypes = new HashMap();
    private static HashMap extensions = new HashMap();
    private static HashMap handlerAssociationsMap = new HashMap();
    private static Logger logger = null;
    public static String EXPORTHANDLER = "FCExporter_";
    public static String RESOURCEPATH = "Resources/";
    public static String SAVEPATH = "./";
    public static String HTTP_URI = "http://yourdomain.com/";
    public static String TMPSAVEPATH = "";
    public static boolean OVERWRITEFILE = false;
    public static boolean INTELLIGENTFILENAMING = true;
    public static String FILESUFFIXFORMAT = "TIMESTAMP";
    static /* synthetic */ Class class$0;

    static {
        handlerAssociationsMap.put("PDF", "PDF");
        handlerAssociationsMap.put("JPEG", "IMG");
        handlerAssociationsMap.put("JPG", "IMG");
        handlerAssociationsMap.put("PNG", "IMG");
        handlerAssociationsMap.put("GIF", "IMG");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("pdf", "application/pdf");
        extensions.put("jpeg", "jpg");
        extensions.put("jpg", "jpg");
        extensions.put("png", "png");
        extensions.put("gif", "gif");
        extensions.put("pdf", "pdf");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.fusioncharts.exporter.FusionChartsExportHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        Properties props = new Properties();
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.fusioncharts.exporter.FusionChartsExportHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            props.load(clazz2.getResourceAsStream("/fusioncharts_export.properties"));
            EXPORTHANDLER = props.getProperty("EXPORTHANDLER", "FCExporter_");
            RESOURCEPATH = props.getProperty("RESOURCEPATH", "Resources" + File.separator);
            SAVEPATH = props.getProperty("SAVEPATH", "./");
            HTTP_URI = props.getProperty("HTTP_URI", "http://yourdomain.com/");
            TMPSAVEPATH = props.getProperty("TMPSAVEPATH", "");
            String OVERWRITEFILESTR = props.getProperty("OVERWRITEFILE", "false");
            OVERWRITEFILE = new Boolean(OVERWRITEFILESTR);
            String INTELLIGENTFILENAMINGSTR = props.getProperty("INTELLIGENTFILENAMING", "true");
            INTELLIGENTFILENAMING = new Boolean(INTELLIGENTFILENAMINGSTR);
            FILESUFFIXFORMAT = props.getProperty("FILESUFFIXFORMAT", "TIMESTAMP");
        }
        catch (NullPointerException e) {
            logger.info("NullPointer: Properties file not FOUND");
        }
        catch (FileNotFoundException e) {
            logger.info("Properties file not FOUND");
        }
        catch (IOException e) {
            logger.info("IOException: Properties file not FOUND");
        }
    }

    public static HashMap bang(String strParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (strParams != null) {
            StringTokenizer stPipe = new StringTokenizer(strParams, "|");
            while (stPipe.hasMoreTokens()) {
                String keyValue = stPipe.nextToken();
                String[] keyValueArr = keyValue.split("=");
                if (keyValueArr.length <= 1) continue;
                params.put(keyValueArr[0].toLowerCase(), keyValueArr[1]);
            }
        }
        return params;
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
            ++i;
        }
        return buf.toString();
    }

    public static String getExporterFilePath(String strFormat) {
        String exporterSuffix = (String)handlerAssociationsMap.get(strFormat) != null ? (String)handlerAssociationsMap.get(strFormat) : strFormat;
        String path = String.valueOf(RESOURCEPATH) + EXPORTHANDLER + exporterSuffix.toUpperCase() + ".jsp";
        return path;
    }

    public static String getExportHandlerClassName(String strFormat) {
        String exporterSuffix = (String)handlerAssociationsMap.get(strFormat.toUpperCase());
        exporterSuffix = exporterSuffix != null ? exporterSuffix : strFormat.toUpperCase();
        String path = String.valueOf(ExportConfiguration.RESOURCEPACKAGE) + "." + ExportConfiguration.EXPORTHANDLER + exporterSuffix.toUpperCase();
        return path;
    }

    public static String getExtensionFor(String format) {
        return (String)extensions.get(format);
    }

    public static HashMap getHandlerAssociationsMap() {
        return handlerAssociationsMap;
    }

    public static String getMimeTypeFor(String format) {
        return (String)mimeTypes.get(format);
    }

    public static HashMap getMimeTypes() {
        return mimeTypes;
    }

    public static String getUniqueFileName(String filePath, String extension) {
        String rand = "" + Math.random();
        String uid = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(rand.getBytes());
            byte[] md5hash = md5.digest();
            uid = FusionChartsExportHelper.convertToHex(md5hash);
        }
        catch (NoSuchAlgorithmException e) {
            logger.info("NoSuchAlgorithmException - Could not generate Unique filename." + e.getMessage());
        }
        String uniqueFileName = String.valueOf(filePath) + "." + extension;
        do {
            uniqueFileName = filePath;
            if (!FILESUFFIXFORMAT.equalsIgnoreCase("TIMESTAMP")) {
                uniqueFileName = String.valueOf(uniqueFileName) + uid + "_" + Math.random();
                continue;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dMyHms");
            String date = sdf.format(Calendar.getInstance().getTime());
            uniqueFileName = String.valueOf(uniqueFileName) + uid + "_" + date + "_" + Calendar.getInstance().getTimeInMillis();
        } while (new File(uniqueFileName = String.valueOf(uniqueFileName) + "." + extension).exists());
        return uniqueFileName;
    }

    public static ExportBean parseExportRequestStream(FusionChartsExportData exportData) {
        ExportBean exportBean = new ExportBean();
        String stream = exportData.getStream();
        String parameters = exportData.getParameters();
        ChartMetadata metadata = new ChartMetadata();
        String strWidth = exportData.getMeta_width();
        String strHeight = exportData.getMeta_height();
        try {
            metadata.setWidth(Integer.parseInt(strWidth));
            metadata.setHeight(Integer.parseInt(strHeight));
        }
        catch (NumberFormatException nfe) {
            metadata.setWidth(-1);
            metadata.setHeight(-1);
        }
        String bgColor = exportData.getMeta_bgColor();
        String DOMId = exportData.getMeta_DOMId();
        metadata.setDOMId(DOMId);
        metadata.setBgColor(bgColor);
        exportBean.setMetadata(metadata);
        exportBean.setStream(stream);
        HashMap exportParamsFromRequest = FusionChartsExportHelper.bang(parameters);
        exportBean.addExportParametersFromMap(exportParamsFromRequest);
        return exportBean;
    }
}

