/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter;

import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import java.io.File;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ErrorHandler {
    private static Logger logger = null;

    static {
        logger = Logger.getLogger(ErrorHandler.class.getName());
    }

    public static String buildResponse(LogMessageSetVO logMessageSetVO, boolean isHTML) {
        String string;
        StringBuffer err_buf = new StringBuffer();
        StringBuffer warn_buf = new StringBuffer();
        String errors = "";
        String notices = "";
        Set<LOGMESSAGE> errorSet = logMessageSetVO.getErrorsSet();
        Set<LOGMESSAGE> warningSet = logMessageSetVO.getWarningSet();
        for (Enum enum_ : errorSet) {
            err_buf.append(enum_.toString());
        }
        for (Enum enum_ : warningSet) {
            err_buf.append(enum_.toString());
        }
        errors = err_buf.length() > 0 ? String.valueOf(isHTML ? "<BR>" : "&") + "statusMessage=" + err_buf.substring(0) + (isHTML ? "<BR>" : "&") + "statusCode=" + Status.FAILURE.getCode() : "statusMessage=" + (Object)((Object)Status.SUCCESS) + "&statusCode=" + Status.SUCCESS.getCode();
        if (warn_buf.length() > 0) {
            notices = String.valueOf(isHTML ? "<BR>" : "&") + "notice=" + warn_buf.substring(0);
        }
        String string2 = (string = logMessageSetVO.getOtherMessages()) == null ? "" : string;
        logger.info("Errors=" + errors);
        logger.info("Notices=" + notices);
        logger.info("Miscellaneous Messages=" + string2);
        return String.valueOf(errors) + notices + string2;
    }

    public static String buildResponse(String eCodes, boolean isHTML) {
        StringTokenizer tokenizer = new StringTokenizer(eCodes, ",");
        StringBuffer err_buf = new StringBuffer();
        StringBuffer warn_buf = new StringBuffer();
        String errors = "";
        String notices = "";
        String errCode = null;
        while (tokenizer.hasMoreTokens()) {
            errCode = tokenizer.nextToken();
            if (errCode.length() <= 0) continue;
            if (errCode.indexOf("E") != -1) {
                err_buf.append((Object)LOGMESSAGE.valueOf(errCode));
                continue;
            }
            warn_buf.append((Object)LOGMESSAGE.valueOf(errCode));
        }
        errors = err_buf.length() > 0 ? String.valueOf(isHTML ? "<BR>" : "&") + "statusMessage=" + err_buf.substring(0) + (isHTML ? "<BR>" : "&") + "statusCode=" + Status.FAILURE.getCode() : "statusMessage=" + (Object)((Object)Status.SUCCESS) + "&statusCode=" + Status.SUCCESS.getCode();
        if (warn_buf.length() > 0) {
            notices = String.valueOf(isHTML ? "<BR>" : "&") + "notice=" + warn_buf.substring(0);
        }
        logger.info("Errors=" + errors);
        logger.info("Notices=" + notices);
        return String.valueOf(errors) + notices;
    }

    public static LogMessageSetVO checkServerSaveStatus(String fileName) {
        LogMessageSetVO errorSetVO = new LogMessageSetVO();
        String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
        File saveFolder = new File(pathToSaveFolder);
        if (!saveFolder.exists()) {
            errorSetVO.addError(LOGMESSAGE.E508);
        } else if (!saveFolder.canWrite()) {
            errorSetVO.addError(LOGMESSAGE.E403);
        } else {
            String completeFilePath = String.valueOf(pathToSaveFolder) + File.separator + fileName;
            File saveFile = new File(completeFilePath);
            if (saveFile.exists()) {
                errorSetVO.addWarning(LOGMESSAGE.W509);
                if (ExportConfiguration.OVERWRITEFILE) {
                    errorSetVO.addWarning(LOGMESSAGE.W510);
                    if (!saveFile.canWrite()) {
                        errorSetVO.addError(LOGMESSAGE.E511);
                    }
                } else if (!ExportConfiguration.INTELLIGENTFILENAMING) {
                    errorSetVO.addError(LOGMESSAGE.E512);
                }
            }
        }
        return errorSetVO;
    }

    public static boolean doesServerSaveFolderExist() {
        boolean saveFolderExists = true;
        String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
        File saveFolder = new File(pathToSaveFolder);
        if (!saveFolder.exists()) {
            saveFolderExists = false;
        }
        return saveFolderExists;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        ERROR,
        WARNING;


        public String toString() {
            return super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LOGMESSAGE {
        E100(" Insufficient data.", ErrorType.ERROR),
        E101(" Width/height not provided.", ErrorType.ERROR),
        W102(" Insufficient export parameters.", ErrorType.WARNING),
        E400(" Bad request.", ErrorType.ERROR),
        E401(" Unauthorized access.", ErrorType.ERROR),
        E403(" Directory write access forbidden.", ErrorType.ERROR),
        E404(" Export Resource not found.", ErrorType.ERROR),
        E507(" Insufficient Storage.", ErrorType.ERROR),
        E508(" Server Directory does not exist.", ErrorType.ERROR),
        W509(" File already exists.", ErrorType.WARNING),
        W510(" Export handler's Overwrite setting is on. Trying to overwrite.", ErrorType.WARNING),
        E511(" Overwrite forbidden. File cannot be overwritten", ErrorType.ERROR),
        E512("Intelligent File Naming is Turned off.", ErrorType.ERROR),
        W513("Background Color not specified. Taking White (FFFFFF) as default background color.", ErrorType.WARNING),
        W514("Using intelligent naming of file by adding unique suffix to the exising name.", ErrorType.WARNING),
        W515("The filename has changed - ", ErrorType.WARNING),
        E516(" Unable to encode buffered image.", ErrorType.ERROR),
        E600("Internal Server Error", ErrorType.ERROR),
        E517(" Invalid Export format.", ErrorType.ERROR);

        private String errorMessage = null;
        private String errorType = null;

        private LOGMESSAGE(String message, ErrorType type) {
            this.errorMessage = message;
            this.errorType = type.toString();
        }

        public String toString() {
            return this.errorMessage;
        }

        public String type() {
            return this.errorType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        SUCCESS(1, "Success"),
        FAILURE(0, "Failure");

        private final int statusCode;
        private final String statusMessage;

        private Status(int statusCode, String statusMessage) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
        }

        public int getCode() {
            return this.statusCode;
        }

        public String toString() {
            return this.statusMessage;
        }
    }
}

