/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.sampledata;

import com.fusioncharts.database.DBConnection;
import com.fusioncharts.sampledata.ChartType;
import com.fusioncharts.sampledata.DOMHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MSFactoriesData {
    protected String chartId = "FactorySum";
    protected String width = "700";
    protected String height = "400";
    protected String filename = ChartType.MSLINE.getFileName();
    protected String xml = null;
    protected String useSingleQuotes = "true";

    private void buildCategoriesXML(Document chartDoc, Element rootElement, ResultSet categoriesResultSet) throws SQLException {
        Element categoriesElem = chartDoc.createElement("categories");
        if (categoriesResultSet.next()) {
            while (categoriesResultSet.next()) {
                String datePro = categoriesResultSet.getString("DatePro");
                Element categoryElem = chartDoc.createElement("category");
                categoryElem.setAttribute("label", datePro);
                categoriesElem.appendChild(categoryElem);
            }
            rootElement.appendChild(categoriesElem);
        }
    }

    private void buildDatasetXML(Document chartDoc, Element rootElement, ResultSet datasetResultSet) throws SQLException {
        String factoryName = null;
        String previousFactoryName = null;
        Element datasetElem = null;
        if (datasetResultSet.next()) {
            while (datasetResultSet.next()) {
                factoryName = datasetResultSet.getString("FactoryName");
                if (!factoryName.equals(previousFactoryName)) {
                    datasetElem = chartDoc.createElement("dataset");
                    datasetElem.setAttribute("seriesName", factoryName);
                }
                String quantity = datasetResultSet.getString("Quantity");
                Element setElem = chartDoc.createElement("set");
                setElem.setAttribute("value", quantity);
                datasetElem.appendChild(setElem);
                if (!factoryName.equals(previousFactoryName)) {
                    rootElement.appendChild(datasetElem);
                }
                previousFactoryName = factoryName;
            }
        }
    }

    public String getChartId() {
        return this.chartId;
    }

    private String getFactoryXML() {
        String strXML = "";
        try {
            DBConnection dbConn = new DBConnection();
            Connection oConn = dbConn.getConnection();
            Statement st1 = null;
            Statement st2 = null;
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            String strCategoryQuery = "";
            String strQuery = "";
            HashMap<String, String> chartAttributes = new HashMap<String, String>();
            chartAttributes.put("caption", "Factory Output report");
            chartAttributes.put("subCaption", "By Quantity");
            chartAttributes.put("xAxisName", "Factory");
            chartAttributes.put("yAxisName", "Units");
            chartAttributes.put("showValues", "0");
            chartAttributes.put("animation", "1");
            chartAttributes.put("formatNumberScale", "0");
            chartAttributes.put("rotateValues", "1");
            DOMHelper domHelper = new DOMHelper();
            Document chartDoc = domHelper.getDocument();
            Element rootElement = chartDoc.createElement("chart");
            domHelper.addAttributesToElement(rootElement, chartAttributes);
            strCategoryQuery = "select distinct DATE_FORMAT(factory_output.DatePro,'%c-%d-%Y') as DatePro from factory_output order by DatePro";
            strQuery = "select factory_master.FactoryName, DATE_FORMAT(factory_output.DatePro,'%c-%d-%Y') as DatePro, factory_output.Quantity from factory_master factory_master, factory_output factory_output where factory_output.FactoryID = factory_master.FactoryId order by factory_output.FactoryID, factory_output.DatePro";
            st1 = oConn.createStatement();
            rs1 = st1.executeQuery(strCategoryQuery);
            this.buildCategoriesXML(chartDoc, rootElement, rs1);
            st1 = oConn.createStatement();
            rs1 = st1.executeQuery(strCategoryQuery);
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the resultset");
            }
            try {
                if (st1 != null) {
                    st1.close();
                    st1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the statement");
            }
            st2 = oConn.createStatement();
            rs2 = st2.executeQuery(strQuery);
            this.buildDatasetXML(chartDoc, rootElement, rs2);
            chartDoc.appendChild(rootElement);
            strXML = domHelper.getXMLString(chartDoc);
            try {
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the resultset");
            }
            try {
                if (st2 != null) {
                    st2.close();
                    st2 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the statement");
            }
            try {
                if (oConn != null) {
                    oConn.close();
                    oConn = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the connection");
            }
        }
        catch (SQLException e) {
            System.out.println("Could not close the statement");
        }
        return strXML;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHeight() {
        return this.height;
    }

    public String getUseSingleQuotes() {
        return this.useSingleQuotes;
    }

    public String getWidth() {
        return this.width;
    }

    public String getXml() {
        this.xml = this.getFactoryXML();
        return this.xml;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setUseSingleQuotes(String useSingleQuotes) {
        this.useSingleQuotes = useSingleQuotes;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }
}

