/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.sampledata;

import com.fusioncharts.database.DBConnection;
import com.fusioncharts.sampledata.ChartType;
import com.fusioncharts.sampledata.DOMHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FactoryDetailsBean {
    protected String chartId = "FactoryDetails";
    protected String width = "600";
    protected String height = "300";
    protected String filename = ChartType.COLUMN2D.getFileName();
    protected String xml = null;
    protected String useSingleQuotes = "true";
    protected String factoryId = "1";

    public String getChartId() {
        return this.chartId;
    }

    private String getFactoryDetailsXML(String factoryId) {
        String strXML = "";
        try {
            DBConnection dbConn = new DBConnection();
            Connection oConn = dbConn.getConnection();
            Statement st = null;
            ResultSet rs = null;
            java.sql.Date date = null;
            Date uDate = null;
            String uDateStr = "";
            String quantity = "";
            String strQuery = "";
            HashMap<String, String> chartAttributes = new HashMap<String, String>();
            chartAttributes.put("caption", "Factory " + factoryId + " Output");
            chartAttributes.put("subCaption", "(In Units)");
            chartAttributes.put("xAxisName", "Date");
            chartAttributes.put("showValues", "1");
            chartAttributes.put("labelStep", "2");
            chartAttributes.put("palette", "2");
            DOMHelper domHelper = new DOMHelper();
            Document chartDoc = domHelper.getDocument();
            Element rootElement = chartDoc.createElement("chart");
            domHelper.addAttributesToElement(rootElement, chartAttributes);
            strQuery = "select * from Factory_Output where FactoryId=" + factoryId + " order by DatePro Asc ";
            st = oConn.createStatement();
            rs = st.executeQuery(strQuery);
            while (rs.next()) {
                date = rs.getDate("DatePro");
                quantity = rs.getString("Quantity");
                if (date != null) {
                    uDate = new Date(date.getTime());
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM");
                    uDateStr = sdf.format(uDate);
                }
                Element setElem = chartDoc.createElement("set");
                setElem.setAttribute("label", uDateStr);
                setElem.setAttribute("value", quantity);
                rootElement.appendChild(setElem);
            }
            chartDoc.appendChild(rootElement);
            strXML = domHelper.getXMLString(chartDoc);
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the resultset");
            }
            try {
                if (st != null) {
                    st.close();
                    st = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the statement");
            }
            try {
                if (oConn != null) {
                    oConn.close();
                    oConn = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the connection");
            }
        }
        catch (SQLException e) {
            System.out.println("Could not close the statement");
        }
        return strXML;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHeight() {
        return this.height;
    }

    public String getUseSingleQuotes() {
        return this.useSingleQuotes;
    }

    public String getWidth() {
        return this.width;
    }

    public String getXml() {
        return this.xml;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
        this.xml = this.getFactoryDetailsXML(factoryId);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setUseSingleQuotes(String useSingleQuotes) {
        this.useSingleQuotes = useSingleQuotes;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }
}

