/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.sampledata;

import com.fusioncharts.sampledata.ChartType;

public class ArrayRenderData {
    protected String xml;
    protected String multiSeriesXml;
    protected String stackedXml;
    protected String combinationXml;
    protected String chartId = "productSales";
    protected String url = null;
    protected String width = "600";
    protected String height = "300";
    protected String filename = ChartType.COLUMN3D.getFileName();
    protected String multiSeriesFilename = ChartType.MSCOLUMN3D.getFileName();
    protected String stackedFilename = ChartType.STACKEDCOLUMN3D.getFileName();
    protected String combinationFilename = ChartType.MSCOLUMN3DLINEDY.getFileName();

    public ArrayRenderData() {
        this.constructSingleSeriesXML();
        this.constructMultiSeriesXML();
        this.constructStackedXML();
        this.constructCombinationXML();
    }

    private void constructCombinationXML() {
        String[][] arrData = new String[4][3];
        arrData[0][0] = "Quarter 1";
        arrData[1][0] = "Quarter 2";
        arrData[2][0] = "Quarter 3";
        arrData[3][0] = "Quarter 4";
        arrData[0][1] = "576000";
        arrData[1][1] = "448000";
        arrData[2][1] = "956000";
        arrData[3][1] = "734000";
        arrData[0][2] = "576";
        arrData[1][2] = "448";
        arrData[2][2] = "956";
        arrData[3][2] = "734";
        this.combinationXml = "<chart palette='4' caption='Product A - Sales Details' PYAxisName='Revenue' SYAxisName='Quantity (in Units)' numberPrefix='$' formatNumberScale='0' showValues='0' decimals='0'>";
        String strCategories = "<categories>";
        String strDataRev = "<dataset seriesName='Revenue'>";
        String strDataQty = "<dataset seriesName='Quantity' parentYAxis='S'>";
        int i = 0;
        while (i < arrData.length) {
            strCategories = String.valueOf(strCategories) + "<category name='" + arrData[i][0] + "' />";
            strDataRev = String.valueOf(strDataRev) + "<set value='" + arrData[i][1] + "' />";
            strDataQty = String.valueOf(strDataQty) + "<set value='" + arrData[i][2] + "' />";
            ++i;
        }
        strCategories = String.valueOf(strCategories) + "</categories>";
        strDataRev = String.valueOf(strDataRev) + "</dataset>";
        strDataQty = String.valueOf(strDataQty) + "</dataset>";
        this.combinationXml = String.valueOf(this.combinationXml) + strCategories + strDataRev + strDataQty + "</chart>";
    }

    private void constructMultiSeriesXML() {
        String[][] arrData = new String[6][3];
        arrData[0][0] = "Product A";
        arrData[1][0] = "Product B";
        arrData[2][0] = "Product C";
        arrData[3][0] = "Product D";
        arrData[4][0] = "Product E";
        arrData[5][0] = "Product F";
        arrData[0][1] = "567500";
        arrData[1][1] = "815300";
        arrData[2][1] = "556800";
        arrData[3][1] = "734500";
        arrData[4][1] = "676800";
        arrData[5][1] = "648500";
        arrData[0][2] = "547300";
        arrData[1][2] = "584500";
        arrData[2][2] = "754000";
        arrData[3][2] = "456300";
        arrData[4][2] = "754500";
        arrData[5][2] = "437600";
        this.multiSeriesXml = "<chart caption='Sales by Product' numberPrefix='$' formatNumberScale='1' rotateValues='1' placeValuesInside='1' decimals='0' >";
        String strCategories = "<categories>";
        String strDataCurr = "<dataset seriesName='Current Year'>";
        String strDataPrev = "<dataset seriesName='Previous Year'>";
        int i = 0;
        while (i < arrData.length) {
            strCategories = String.valueOf(strCategories) + "<category name='" + arrData[i][0] + "' />";
            strDataCurr = String.valueOf(strDataCurr) + "<set value='" + arrData[i][1] + "' />";
            strDataPrev = String.valueOf(strDataPrev) + "<set value='" + arrData[i][2] + "' />";
            ++i;
        }
        strCategories = String.valueOf(strCategories) + "</categories>";
        strDataCurr = String.valueOf(strDataCurr) + "</dataset>";
        strDataPrev = String.valueOf(strDataPrev) + "</dataset>";
        this.multiSeriesXml = String.valueOf(this.multiSeriesXml) + strCategories + strDataCurr + strDataPrev + "</chart>";
    }

    private void constructSingleSeriesXML() {
        String[][] arrData = new String[6][2];
        arrData[0][0] = "Product A";
        arrData[1][0] = "Product B";
        arrData[2][0] = "Product C";
        arrData[3][0] = "Product D";
        arrData[4][0] = "Product E";
        arrData[5][0] = "Product F";
        arrData[0][1] = "567500";
        arrData[1][1] = "815300";
        arrData[2][1] = "556800";
        arrData[3][1] = "734500";
        arrData[4][1] = "676800";
        arrData[5][1] = "648500";
        int i = 0;
        this.xml = "<chart caption='Sales by Product' numberPrefix='$' formatNumberScale='0'>";
        i = 0;
        while (i < arrData.length) {
            this.xml = String.valueOf(this.xml) + "<set label='" + arrData[i][0] + "' value='" + arrData[i][1] + "' />";
            ++i;
        }
        this.xml = String.valueOf(this.xml) + "</chart>";
    }

    private void constructStackedXML() {
        String[][] arrData = new String[4][3];
        arrData[0][0] = "Quarter 1";
        arrData[1][0] = "Quarter 2";
        arrData[2][0] = "Quarter 3";
        arrData[3][0] = "Quarter 4";
        arrData[0][1] = "567500";
        arrData[1][1] = "815300";
        arrData[2][1] = "556800";
        arrData[3][1] = "734500";
        arrData[0][2] = "547300";
        arrData[1][2] = "594500";
        arrData[2][2] = "754000";
        arrData[3][2] = "456300";
        this.stackedXml = "<chart caption='Sales' numberPrefix='$' formatNumberScale='0' chartLeftMargin='50' chartRightMargin='50'>";
        String strCategories = "<categories>";
        String strDataProdA = "<dataset seriesName='Product A'>";
        String strDataProdB = "<dataset seriesName='Product B'>";
        int i = 0;
        while (i < arrData.length) {
            strCategories = String.valueOf(strCategories) + "<category name='" + arrData[i][0] + "' />";
            strDataProdA = String.valueOf(strDataProdA) + "<set value='" + arrData[i][1] + "' />";
            strDataProdB = String.valueOf(strDataProdB) + "<set value='" + arrData[i][2] + "' />";
            ++i;
        }
        strCategories = String.valueOf(strCategories) + "</categories>";
        strDataProdA = String.valueOf(strDataProdA) + "</dataset>";
        strDataProdB = String.valueOf(strDataProdB) + "</dataset>";
        this.stackedXml = String.valueOf(this.stackedXml) + strCategories + strDataProdA + strDataProdB + "</chart>";
    }

    public String getChartId() {
        return this.chartId;
    }

    public String getCombinationFilename() {
        return this.combinationFilename;
    }

    public String getCombinationXml() {
        return this.combinationXml;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHeight() {
        return this.height;
    }

    public String getMultiSeriesFilename() {
        return this.multiSeriesFilename;
    }

    public String getMultiSeriesXml() {
        return this.multiSeriesXml;
    }

    public String getStackedFilename() {
        return this.stackedFilename;
    }

    public String getStackedXml() {
        return this.stackedXml;
    }

    public String getUrl() {
        return this.url;
    }

    public String getWidth() {
        return this.width;
    }

    public String getXml() {
        return this.xml;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public void setCombinationFilename(String combinationFilename) {
        this.combinationFilename = combinationFilename;
    }

    public void setCombinationXml(String combinationXml) {
        this.combinationXml = combinationXml;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setMultiSeriesFilename(String multiSeriesFilename) {
        this.multiSeriesFilename = multiSeriesFilename;
    }

    public void setMultiSeriesXml(String multiSeriesXml) {
        this.multiSeriesXml = multiSeriesXml;
    }

    public void setStackedFilename(String stackedFilename) {
        this.stackedFilename = stackedFilename;
    }

    public void setStackedXml(String stackedXml) {
        this.stackedXml = stackedXml;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }
}

